﻿Function Get-ConnectionType {
   $WirelessAdapters =  Get-CimInstance -Namespace "root\WMI" -Class MSNdis_PhysicalMediumType -Filter `
        'NdisPhysicalMediumType = 9'
    $WiredAdapters = Get-CimInstance -Namespace "root\WMI" -Class MSNdis_PhysicalMediumType -Filter `
        "NdisPhysicalMediumType = 0 and `
        (NOT InstanceName like '%pangp%') and `
        (NOT InstanceName like '%cisco%') and `
        (NOT InstanceName like '%juniper%') and `
        (NOT InstanceName like '%vpn%') and `
        (NOT InstanceName like 'Hyper-V%') and `
        (NOT InstanceName like 'VMware%') and `
        (NOT InstanceName like 'VirtualBox Host-Only%')"
    $ConnectedAdapters =  Get-CimInstance -Class win32_NetworkAdapter -Filter `
        'NetConnectionStatus = 2'
    $VPNAdapters =  Get-CimInstance -Class Win32_NetworkAdapterConfiguration -Filter `
        "Description like '%pangp%' `
        or Description like '%cisco%'  `
        or Description like '%juniper%' `
        or Description like '%vpn%'"


        Foreach($Adapter in $ConnectedAdapters) {
    If($WirelessAdapters.InstanceName -contains $Adapter.Name)
    {
        $WirelessConnected = $true
    }
}

Foreach($Adapter in $ConnectedAdapters) {
    If($WiredAdapters.InstanceName -contains $Adapter.Name)
    {
        $WiredConnected = $true
    }
}

Foreach($Adapter in $ConnectedAdapters) {
    If($VPNAdapters.Index -contains $Adapter.DeviceID)
    {
        $VPNConnected = $true
    }
}

If(($WirelessConnected -ne $true) -and ($WiredConnected -eq $true)){ $ConnectionType="WIRED"}
If(($WirelessConnected -eq $true) -and ($WiredConnected -eq $true)){$ConnectionType="WIRED AND WIRELESS"}
If(($WirelessConnected -eq $true) -and ($WiredConnected -ne $true)){$ConnectionType="WIRELESS"}
If($VPNConnected -eq $true){$ConnectionType="VPN"}

Return $ConnectionType
}
$connection = Get-ConnectionType
If ($connection -ne "VPN") {
$msi = (Get-childItem -Path "$PSScriptRoot" -Filter "*.msi").FullName
$switches = "/i `"$msi`" /qn PORTAL=`"ra.applied.com`" ALLUSERS=1 REBOOT=ReallySuppress CONNECTMETHOD=`"on-demand`""
Start-Process msiexec.exe -ArgumentList "$switches" -Wait
#
If (-not(Get-Item -Path 'HKLM:\SOFTWARE\Palo Alto Networks\GlobalProtect\CBL')) {
New-Item -Path 'HKLM:\software\Palo Alto Networks\GlobalProtect\CBL'
}
New-ItemProperty -Path 'HKLM:\software\Palo Alto Networks\GlobalProtect\CBL' -Name "Portal1" -Value "ra.applied.com" -Force
If (-not(Get-Item -Path 'HKLM:\SOFTWARE\Palo Alto Networks\GlobalProtect\Settings')) {
New-Item -Path 'HKLM:\software\Palo Alto Networks\GlobalProtect\Settings'
}
New-ItemProperty -Path 'HKLM:\software\Palo Alto Networks\GlobalProtect\Settings' -Name "connect-method" -Value "on-demand" -Force
New-ItemProperty -Path 'HKLM:\software\Palo Alto Networks\GlobalProtect\Settings' -Name "on-demand" -Value "yes" -Force
#>
Start-Process "C:\Program Files\Palo Alto Networks\GlobalProtect\PanGPS.exe" -ArgumentList " -registerplap"
}
Else {
Write-Host "Connected over VPN, Install Cancelled"
Exit 7
}
