﻿$localtz = [System.TimeZoneInfo]::Local | select-object -expandproperty Id
$filter = "(&(objectCategory=computer)(objectClass=computer)(cn=$env:COMPUTERNAME))"
If ($env:userdomain -ne $env:COMPUTERNAME) {
$compDN = ([ adsisearcher ] $filter).FindOne().Properties.distinguishedname
}
else {$compDN = $env:COMPUTERNAME}
write-host "Computer Name: $compDN`nTime Zone: $localtz`n" -ForegroundColor Yellow
$installed = (get-package | where {$_.providername -in @("Programs","msi")} | sort name).name
$appx = (Get-AppxPackage -name "MSTeams").Name
If ($appx) {

$installed = $installed + $appx
}
$offinst = $installed | where {$_ -like "Microsoft Office Standard*" -or $_ -like "Microsoft 365*"} | select -Unique
If ($offinst -eq $null) {$offinst = "Microsoft Office"}
$taninst = $installed | where {$_ -like "Tanium*"} | select -unique
If ($taninst -eq $null) {$taninst = "Tanium Client"}
$adobe = $installed | where {$_ -like "adobe acrobat*"} | select -unique
If ($adobe -eq $null) {$adobe = "Adobe Acrobat Reader"}
$verified = @()
$list = "Configuration Manager Client","Sentinel Agent","MSTeams","$adobe","$offinst","$taninst"
$ltList = "Sophos Endpoint Agent","GlobalProtect"
If ($env:computername -like "*-LT") {
$list = $list + $ltList
}
$cmpsw = compare $list $installed | where sideindicator -eq "<="
$verified = compare $list $installed -IncludeEqual | where sideindicator -eq "=="
If ($cmpsw) {
$cmpsw | Select-Object -property @{Name='Missing Software';expression={$_.InputObject}} | Out-Host
}
else {write-host "All Software Installed`n----Installed Software---`n"
$verified.inputobject | sort | Out-Host}
Invoke-Expression -command "mmc.exe devmgmt.msc"
Read-Host "`Press Enter to Exit"