﻿
$adminrole = ([Security.Principal.WindowsBuiltInRole] "Administrator")
$wid = ([Security.Principal.WindowsPrincipal] [Security.Principal.WindowsIdentity]::GetCurrent()) 

<# If not running with administrative privileges...
If (-not $wid.IsInRole($adminrole)) {
    
    # Prepare to relaunch the script with elevated rights
    $newProcess = New-Object System.Diagnostics.ProcessStartInfo "PowerShell"
    
    # Pass the current script's path as argument so it relaunches itself
    $newProcess.Arguments = $myInvocation.MyCommand.Definition
    
    # Use 'runas' to trigger UAC elevation prompt
    $newProcess.Verb = "runas"
    
    # Start the new elevated process
    [System.Diagnostics.Process]::Start($newProcess)
    
    # Exit the current (non-elevated) process to avoid duplicate execution
    exit
}
#>
Function Display-WaitForm {
Param (
$Titletext = "Title",
$LabelText = "Label"
)

Add-Type -AssemblyName System.Windows.Forms
$global:Displayform = New-Object system.Windows.Forms.Form -Property @{TopMost = $true}
$Displayform.Text = "$Titletext"
$Displayform.StartPosition = "CenterScreen"
$Displayform.size = New-Object System.Drawing.Size(500,65)
$Displayform.ControlBox = $false
#$Displayform.AutoSizeMode = "GrowAndShrink"
$Font = New-Object System.Drawing.Font("Times New Roman",14,[System.Drawing.FontStyle]::Regular)
$Displayform.Font = $Font
$Label = New-Object System.Windows.Forms.Label
$Label.Text = "`r   $labeltext   `r"
$Label.AutoSize = $True
$Displayform.Controls.Add($Label)
$Displayform.Show()

}

Function Get-DellWarranty {
Param (
$serialNumber
)
# Call Dell Warranty API to get auth token
$authheaders = New-Object "System.Collections.Generic.Dictionary[[String],[String]]"
$authheaders.Add("Content-Type", "application/x-www-form-urlencoded")
$authbody = "client_id=l7c330fadac5d34402b92edf4583c3862f&client_secret=faf152833f1f4f5ea6219bc3270bf4e0&grant_type=client_credentials"
$authresponse = Invoke-RestMethod 'https://apigtwb2c.us.dell.com/auth/oauth/v2/token' -Method 'POST' -Headers $authheaders -Body $authbody

# Parse Token
$accessToken = $authresponse.access_token

# Call the Warranty PAI and pass the serial and auth token
$headers = New-Object "System.Collections.Generic.Dictionary[[String],[String]]"
$headers.Add("Authorization", "Bearer {0}" -f $accessToken)
$request = 'https://apigtwb2c.us.dell.com/PROD/sbil/eapi/v5/asset-entitlements?servicetags={0}' -f $serialNumber

$response = Invoke-RestMethod $request -Method 'GET' -Headers $headers
$Warranty = $response | Select-Object -ExpandProperty entitlements | sort StartDate,Entitlement
$return = $null
If ($Warranty) {
$start = Get-Date ($Warranty | select -first 1).StartDate -Format MM/dd/yyyy
$end = Get-Date ($Warranty | select -Last 1).EndDate -Format MM/dd/yyyy
$Name = ($Warranty | select -Last 1).ServiceLevelDescription
$Return = New-Object -TypeName PSObject -Property @{
Name = $Name
Start = $start
End = $end
}
}
Return $return | select Start,End,Name
}

Function Get-LenovoWarranty {
param (
$SerialNumber
)
$Return = $null
$ClientId = 'z/6pxXWSTKbRHi6RW1zMqA=='
$query = "Serial=$SerialNumber"

$headers = @{
    'ClientId' = $ClientId
};

$ApiObject = Invoke-RestMethod -Uri "http://supportapi.lenovo.com/V2.5/Warranty?$query" -Headers $headers;
$Warranty = $ApiObject | select -ExpandProperty Warranty | sort Start,Type
If ($warranty) {
$start = Get-Date ($Warranty | select -first 1).Start -Format MM/dd/yyyy
$end = Get-Date ($Warranty | select -Last 1).End -Format MM/dd/yyyy
$Name = ($Warranty | select -Last 1).Name
$Return = New-Object -TypeName PSObject -Property @{
Name = $Name
Start = $start
End = $end
}
}
Return $return | select Start,End,Name
}

function Remove-Diacritics {
param ([String]$src = [String]::Empty)
  $normalized = $src.Normalize( [Text.NormalizationForm]::FormD )
  ($normalized -replace '\p{M}', '')
}

Function Set-FormBase {
Param (
$TitleText = "Add Computer to APPLIEDGLOBAL",
$Width = (1024),
$height = (768)
)
$form.TopMost = $true
$form.Text = $TitleText
$form.Size = New-Object System.Drawing.Size($width,$Height)
$form.StartPosition = "CenterScreen"
#$form.Font = $Font
$Form.BackColor = "#ffffff"
$form.ShowDialog()
$form.Focus()

}

Function Load-FormObjects {
$form = New-Object System.Windows.Forms.Form
$file = Get-item "$PSScriptroot\Applied.jpg"
$img = [System.Drawing.Image]::Fromfile($file);
$picturebox = New-Object Windows.Forms.PictureBox
$pictureBox.Size = New-Object System.Drawing.Size($img.Width,$img.Height)
$pictureBox.Image = $img
$pictureBox.SizeMode = [System.Windows.Forms.PictureBoxSizeMode]::CenterImage
$pictureBox.Dock = [System.Windows.Forms.DockStyle]::Top
$Form.controls.add($pictureBox)
$ReviewButton = New-Object System.Windows.Forms.Button
$ReviewResultlabel = New-Object System.Windows.Forms.Label
$CreateButton = New-Object System.Windows.Forms.Button
$CreateButton.Location = New-Object System.Drawing.Point(900,650)
$CreateButton.Add_Click({
. Create-Button

})
$ReviewData = New-Object System.Windows.Forms.Label
$adminpasstextBox = New-Object System.Windows.Forms.MaskedTextBox
$adminpasslabelBox = New-Object System.Windows.Forms.Label
$adminuserlabelBox = New-Object System.Windows.Forms.Label
$adminusertextBox = New-Object System.Windows.Forms.TextBox
$FirsttextBox = New-Object System.Windows.Forms.TextBox
$FirstlabelBox = New-Object System.Windows.Forms.Label
$MiddletextBox = New-Object System.Windows.Forms.TextBox
$MiddlelabelBox = New-Object System.Windows.Forms.Label
$LasttextBox = New-Object System.Windows.Forms.TextBox
$LastlabelBox = New-Object System.Windows.Forms.Label
$TitletextBox = New-Object System.Windows.Forms.TextBox
$TitlelabelBox = New-Object System.Windows.Forms.Label
$LocationtextBox = New-Object System.Windows.Forms.TextBox
$LocationlabelBox = New-Object System.Windows.Forms.Label
$MgrtextBox = New-Object System.Windows.Forms.TextBox
$MgrlabelBox = New-Object System.Windows.Forms.Label
$NewNametextBox = New-Object System.Windows.Forms.TextBox
$NewNamelabel = New-Object System.Windows.Forms.Label
$DepttextBox = New-Object System.Windows.Forms.TextBox
$DeptlabelBox = New-Object System.Windows.Forms.Label
$locDropDownList = New-Object System.Windows.Forms.ComboBox
$locDropdownLabel = New-Object System.Windows.Forms.Label
$UserDropDownList = New-Object System.Windows.Forms.ComboBox
$UserDropdownLabel = New-Object System.Windows.Forms.Label
$userpasstextBox = New-Object System.Windows.Forms.MaskedTextBox
$UserpasslabelBox = New-Object System.Windows.Forms.Label
$labelAuth = New-Object System.Windows.Forms.Label
$Inputlabel = New-Object System.Windows.Forms.Label
$AdAuthlabel = New-Object System.Windows.Forms.Label
$Authlabel = New-Object System.Windows.Forms.Label
$AdAuthbutton = New-Object System.Windows.Forms.Button
$ADAuthbutton.Location = New-Object System.Drawing.Point(105,225)
$ADAuthbutton.Size = New-Object System.Drawing.Size(93,25)
$NewNameCheckBox = new-object System.Windows.Forms.checkbox
$365CheckBox = new-object System.Windows.Forms.checkbox
$PowerBICheckBox = new-object System.Windows.Forms.checkbox
$ADAuthbutton.Text = 'Authenticate'
. Authenticate
# Input-UserData
# Review-Buttons
#. Set-365
}

Function Authenticate {
Param (
[string]$labeltxt = "Enter $DNSRoot Administrator Credentials.  Click Authenticate when ready.",
[string]$adminusernametxt = "$NetBIOS\",
[string]$ADAuth = $false
)


$domain = $null
$form.Controls.Add($ADAuthButton)
$form.Controls.Add($CancelButton)

#Username/Password Boxes
$Authlabel.Location = New-Object System.Drawing.Point(30,126)
$Authlabel.AutoSize = $true
$Authlabel.Text = $labelTxt
$form.Controls.Add($Authlabel)
$form.Controls.Add($CancelAnyLabel)
$adminuserlabelBox.Location = New-Object System.Drawing.Point(30,164)
$adminuserlabelBox.Size = New-Object System.Drawing.Size(70,20)
$adminuserlabelBox.Text = "Username"
$adminusertextBox.Location = New-Object System.Drawing.Point(105,164)
$adminusertextBox.Size = New-Object System.Drawing.Size(250,20)
$adminusertextBox.Text = $adminusernameTxt
$adminusertextBox.AutoSize = $true
$form.Controls.Add($adminusertextBox)
$form.Controls.Add($adminuserlabelBox)
$adminpasslabelBox.Location = New-Object System.Drawing.Point(30,196)
$adminpasslabelBox.Size = New-Object System.Drawing.Size(70,20)
$adminpasslabelBox.Text = "Password"
$adminpasstextBox.PasswordChar = "*"
$adminpasstextBox.Location = New-Object System.Drawing.Point(105,194)
$adminpasstextBox.Size = New-Object System.Drawing.Size(250,20)

$labelAuth.Location = New-Object System.Drawing.Point(345,188)
$labelAuth.AutoSize = $true #New-Object System.Drawing.Size(300,25)

$adminpasstextBox.AutoSize = $true
$form.Controls.Add($adminpasstextBox)
$form.Controls.Add($adminpasslabelBox)
$form.Controls.Add($adminuserlabelBox)

$form.Refresh()

}

Function Set-Buttons {
$ADAuthbutton.Add_Click({
$form.Controls.Remove($labelAuth)
#$form.Controls.Remove($MyGroupBox)
$Global:authtype = "AD"
$global:pwd =  ConvertTo-SecureString $adminpasstextBox.Text -AsPlainText -Force 
$global:admin = $adminusertextbox.Text
If ($($adminpasstextBox.Text.Length) -gt 0) {
. Test-Cred -adminusername $admin -pass $pwd
}
})

$locDropDownList_SelectedIndexChanged={
. Review-Buttons
}

$NewNameCheckbox.Add_CheckStateChanged({
If ($NewNameCheckbox.Checked) {
Add-NewNameTextBox

}
else {
Add-NewNameTextBox
#$form.Controls.Add($Reviewbutton)
}
})


}

Function Test-Cred {
           
    [CmdletBinding()]
    [OutputType([String])] 
       
    Param ( 

$adminusername,
$pass
    )
$ADSI = $null
$labelAuth.Location = New-Object System.Drawing.Point(215,228)
$global:Cred = New-Object System.Management.Automation.PSCredential -ArgumentList $adminuserName, $pass
$global:domain = $ADSI = New-Object System.DirectoryServices.DirectoryEntry("LDAP://$domainController", $cred.UserName, $cred.GetNetworkCredential().Password)
$global:searcher = New-Object System.DirectoryServices.DirectorySearcher($domain)
  
    If ($adsi.path) {
       $labelAuth.Text = "Authenticated"
	   $labelAuth.ForeColor = "Black"
	   $pwd = ""
       $pass = ""
       $form.Controls.Remove($labelAuth)
	   $form.Controls.Remove($ADAuthbutton)
       $form.Controls.Add($labelAuth)
	   $adminpasstextBox.Text = ""
	   $form.Controls.Remove($adminpasstextBox)
       $global:irisusers = Get-ADData -class user -attrib extensionAttribute10 -search 9529
       #$form.Controls.Add($adminpasstextBox)
      . Input-UserData
      . Review-Buttons
     # . Set-365


    }
    Else {
           #$labelAuth.Location = New-Object System.Drawing.Point(85,225)
       $labelAuth.Text = "Not Authenticated"
       $labelAuth.ForeColor = "RED"
       $form.Controls.Remove($labelAuth)
       sleep -Milliseconds 300
       $form.Controls.Add($labelAuth)

	}
		
        }

Function Add-NewNameTextBox {
$x = 30
$y = 265
$m = 30
#$x = 600
#$y = 126
$NewNameLabel.Location = New-Object System.Drawing.Point(($x),($y+2+(4*$m)))
$NewNameLabel.Size = New-Object System.Drawing.Size(70,20)
$NewNameLabel.Text = "UserName"
$NewNameTextBox.Location = New-Object System.Drawing.Point(($x+75),($y+(4*$m)))
$NewNameTextBox.Size = New-Object System.Drawing.Size(175,20)

$adds = @($NewNameLabel,$NewNameTextBox)
If ($NewNameCheckBox.CheckState -eq $true) {
$adds | foreach {$form.Controls.Add($_)}
Review-Buttons
}
else {
$adds | foreach {$form.Controls.Remove($_)}
}
}

Function Input-UserData {
Param (
[string]$labeltxt = "Enter user information below.  Click Review when ready.",
[string]$adminusernametxt = "$NetBIOS\",
[string]$ADAuth = $false
)
$x = 30
$y = 265
$m = 30
#$x = 600
#$y = 126
$locDropdownLabel.Location = New-Object System.Drawing.Point(($x),($y+2+($m)))
$locDropdownLabel.Size = New-Object System.Drawing.Size(70,20)
$locDropdownLabel.Text = "Users"
$locDropDownList.Location = New-Object System.Drawing.Point(($x+75),($y+($m)))
$locDropDownList.Size = New-Object System.Drawing.Size(175,20)
$locDropDownList.Items.AddRange(@($irisusers.name | sort))
$NewNameCheckBox.Location = New-Object System.Drawing.Point(($x),($y+(2*$m)))
$NewNameCheckBox.Text = "Click to enter missing user name"
$NewNameCheckBox.AutoSize = $true
$locDropDownList_SelectedIndexChanged={
. Review-Buttons
}
$locDropDownList.add_SelectedIndexChanged($locDropDownList_SelectedIndexChanged)
$adds = @($locDropdownLabel,$locDropDownList,$NewNameCheckBox)
$adds | foreach {$form.Controls.Add($_)}

$form.Refresh()

}

Function Set-PCName {
Param (
    $fLoc,
    $fname,
    $ftype
    )
    $results = $null
    Do {
     $value = ($fname.Substring($fname.Length-4) + (Random))
     $cname = "$floc-$value-$ftype"
     $Search = New-Object DirectoryServices.DirectorySearcher("(&(objectCategory=computer)(name=$cname))")
    $Results = $Search.FindAll()
             } 
            until ($results.path.length -lt 2)
      Return $cname
                }

Function Random {
    $num = Get-Random -Minimum 0 -Maximum 9
    $num2 = Get-Random -Minimum 0 -Maximum 9
    $allowedChr = [Char[]]'ABCDEFGHJKLMNPQRSTUVWXYZ'
    #$num = "{0:D2}" -f $num
    $chr =  ($allowedChr | get-random -count 1)
    $chr2 =   ($allowedChr | get-random -count 1)
   
    If ($warranty -eq $true) {
    $rnd = "$chr$chr2$num"
    }
    else {
    $rnd = "$chr$num$num2"
    }
   Return $rnd
   }

Function Review-Buttons {
$form.Controls.Add($ReviewLabel)
$Reviewbutton.Location = New-Object System.Drawing.Point(30,650)
$Reviewbutton.Autosize = $true
$Reviewbutton.Text = 'Review'
$form.Controls.Add($Reviewbutton)
$CreateButton.Location = New-Object System.Drawing.Point(900,650)
$CreateButton.Autosize = $true
$CreateButton.Text = 'Join'
$Reviewbutton.Add_Click({
 #  $ADSI = New-Object System.DirectoryServices.DirectoryEntry("LDAP://$domainController", "$admin", "$pwd")
<#   $searcher = New-Object System.DirectoryServices.DirectorySearcher($ADSI)
$Global:site = $locdata | where {$_.loc -eq ($locDropdownList.SelectedItem).Substring(0,4) -and $_.OU -like "*$oufolder*"}
If ($site.loc -eq "9512" -and ($locDropdownList.SelectedItem).Substring(0,5) -eq "9512B") {
$site = $locdata | where {$_.loc -eq "9512B" -and $_.OU -like "*$oufolder*"}
}
#>
If ($NewNameCheckbox.Checked) {
$selecteduser = $NewNametextBox.Text
$global:irisuser = Get-ADData -class user -attrib samaccountname -search $selecteduser
}
else {
$selecteduser = $locDropdownList.SelectedItem
$global:irisuser = Get-ADData -class user -attrib name -search $selecteduser
}
$loc = "9529"
$global:OUPath = "OU=$oufolder,OU=Iris,OU=PCs,OU=Computers,OU=AIT-Automation,DC=applied,DC=global"
$global:TimeZone = "Central Standard Time"
$global:scCode = "ir"
$global:token = "eyJ1cmwiOiAiaHR0cHM6Ly91c2VhMS0wMTcuc2VudGluZWxvbmUubmV0IiwgInNpdGVfa2V5IjogImdfYjBkNjc3N2M5MjgyODc4NyJ9"

$Global:cmpname = Set-PCName -fLoc $loc -fname $YearMonth -ftype $type
    $searcher.Filter = "(&(objectClass=computer)(name=$cmpname))"
    $searcher.SearchScope = "Subtree"
    $check = $searcher.Findone()
If (!$check) {
$value = @{Description = "$description"}
Set-CimInstance -Query 'Select * From Win32_OperatingSystem' -Property $value #-ComputerName $computer

$global:newName = $cmpname
$adPath = $OUPath -replace ,"" -replace ",OU=","/" -replace ",dc=applied,dc=global",""
							$global:Reviewlabel = "$adpath`nTimeZone: $TimeZone`nComputerName: $cmpName`nDescription: $description`nNext Logon User:  $($irisuser.samaccountname)" 
							Review-Result -label $reviewLabel -y 300 -x 380
#. Review-Result -label "$env:computername will be joined to $DNSRoot`nas $newname"
$form.Controls.Add($CreateButton)
}
elseIf (!$check2) {

. Review-Result -label "$newname found in $DNSRoot.`nPlease investigate existence of $cmpname." 
#$form.Controls.Add($CreateButton)

}
else {
. Review-Result -label "This computername $env:computername exists in`n$DNSRoot.  Please close script and`ninvestigate if $env:computername can be deleted`nOr rename this computer and rerun script."
}
})

}

Function Get-ADData {
param (
$class,
$attrib,
$search
)
$searcher.Filter = "(&(objectClass=$class)($attrib=$search))"
$searcher.SearchScope = "Subtree"
$results = $searcher.FindAll()
Return $results.properties
}

Function Set-Description {
$searcher.Filter = "(&(objectClass=computer)(name=$cmpname))"
$searcher.SearchScope = "Subtree"
$adcomputer = $Searcher.FindOne()	
if ($adcomputer) {   	  
    $update = $adcomputer.GetDirectoryEntry()
    $update.Description = "$description"
    $update.CommitChanges()
    }
}

Function Review-Result {
Param (
$label = "Label",
$x = 450,
$y = 125
)
$form.Controls.Remove($reviewresultLabel)
$reviewresultLabel.Location = New-Object System.Drawing.Point($x,$y)
$reviewresultLabel.AutoSize = $true
$reviewresultLabel.Text = $label
$reviewresultLabel.Font = New-Object System.Drawing.Font("Arial", 12, [System.Drawing.FontStyle]::Regular)
$form.Controls.Add($reviewresultLabel)
$form.Refresh()
}

Function Migrate-User {
param (
$localaccount,
$samaccount
)
$migfile = "C:\drivers\usermigrate.csv"
If (Test-Path $migfile) {Clear-Content $migfile}
$users = "$localaccount,$samaccount"
Set-Content -Path $migfile -Value $users
If ($local[0] -eq "AzureAD") {
Rename-Item "$PSScriptRoot\Profiwiz.config" "ProfiwizLocal.config" -Force
Rename-Item "$PSScriptRoot\ProfiwizAZ.config" "Profiwiz.config" -Force
}
$profwiz = Start-Process -FilePath "$PSScriptRoot\Profwiz.exe" -Wait -PassThru

$profwiz.WaitForExit()
Restart-Computer -Force
}

Function Create-Button {
Display-WaitForm -Titletext "Please Wait" -LabelText "Gathering computer information"
$global:installed = Get-Package
& "$PSScriptRoot\AppliedSupportMenu1.10\CopyShrtcuts.bat"
$displayform.Close()

###### Install Sentinel One ########
If (-not($installed | where name -like "Sentinel Agent*")) {
Display-WaitForm -Titletext "Installing Security Agents Before Joining Domain" -LabelText "Please wait while Sentinel One is installed"
$installer = (get-childitem "$PSScriptRoot\SentinelOne" -Filter "*.exe").Fullname
$argSent = "-q -f -t $token"
Start-Process "$installer" -ArgumentList "$argSent" -Wait
$displayform.Close()
}

###### Install Screen Connect ########
If (-not($installed | where name -like "ScreenConnect Client*")) {
Display-WaitForm -Titletext "Installing Security Agents Before Joining Domain" -LabelText "Please wait while Screen Connect is installed"
$msi = "$scCode" + "-ScreenConnect.ClientSetup.msi"
$arglist = "/i `"$PSScriptRoot\ScreenConnect\$msi`" /qn"
Start-Process msiexec -ArgumentList "$arglist" -Wait
$displayform.Close()
}

###### Install LAPS ########
If (-not($installed | where name -like "Local Administrator Password*")) {
Display-WaitForm -Titletext "Installing Security Agents Before Joining Domain" -LabelText "Please wait while LAPS is installed"
$arglaps = "/i `"$PSScriptRoot\LAPS\LAPS.x64.msi`" /qn ALLUSERS=2"
Start-Process msiexec -ArgumentList "$arglaps" -Wait
$displayform.Close()
}
 If ($local[0] -eq "azuread") {
DSREGCMD /Leave
}
$setParams = @{
Server = "$DomainController"
DomainName = $DNSRoot
NewName = $newname
OUPath = $OuPath
Credential = $Cred
}
$setParams
Add-Computer @setParams
If ((gwmi win32_computersystem).Domain -eq $DNSRoot) {
    Set-Description
    Set-TimeZone $TimeZone
	$form.Controls.Remove($ReviewLabel)
	$form.Refresh()
	Review-Result -label "Successfully joined $DNSRoot"
<#
Set-ItemProperty "HKLM:\SOFTWARE\Microsoft\Windows\CurrentVersion\Authentication\LogonUI" -Name "LastLoggedOnDisplayName" -Value "$($irisuser.name)"
Set-ItemProperty "HKLM:\SOFTWARE\Microsoft\Windows\CurrentVersion\Authentication\LogonUI" -Name "LastLoggedOnSAMUser" -Value "$($irisuser.samaccountname)"
Set-ItemProperty "HKLM:\SOFTWARE\Microsoft\Windows\CurrentVersion\Authentication\LogonUI" -Name "LastLoggedOnUser" -Value "$($irisuser.name)"
#>
REG ADD "HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows\CurrentVersion\Authentication\LogonUI" -v "LastLoggedOnDisplayName" -d "$($irisuser.name)" -t REG_SZ -f
REG ADD "HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows\CurrentVersion\Authentication\LogonUI" -v "LastLoggedOnSAMUser" -d "$($irisuser.samaccountname)" -t REG_SZ -f
REG ADD "HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows\CurrentVersion\Authentication\LogonUI" -v "LastLoggedOnUser" -d "$($irisuser.name)" -t REG_SZ -f
REG ADD "HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\Control\CI\Policy" -t REG_DWORD -v VerifiedAndReputablePolicyState -d 0 -f
$form.Controls.Remove($CreateButton)
. Install-Software
#. Migrate-User -localaccount $local[-1] -samaccount $irisuser.samaccountname

	else {
	$form.Controls.Remove($ReviewLabel)
	Review-Result -label "Failed to join $DNSRoot"
$form.Controls.Remove($CreateButton)
	}
	

}
}
#
Function Install-Software {
###### Install Tanium ########
If (-not($installed | where name -like "Tanium Client*")) {
Display-WaitForm -Titletext "Installing Software" -LabelText "Please wait while Tanium is installed"
$installer = (get-childitem "$PSScriptRoot\Tanium" -Filter "*.exe").Fullname
$tanArg =  " /S /serverAddress=applied-zsb1.cloud.tanium.com /Keypath=`"$PSScriptRoot\Tanium\tanium-init.dat`""
Start-Process "$installer" -ArgumentList "$tanArg" -Wait
$displayform.Close()
}

###### Install Sophos ########
If (-not($installed | where {$_.name -like "Sophos*"}) -and (Get-TPM).tpmPresent -eq $true) {
Display-WaitForm -Titletext "Installing Software" -LabelText "Please wait while Sophos is installed"
$installer = (get-childitem "$PSScriptRoot\Sophos" -Filter "*.exe").Fullname
Start-Process "$installer" -ArgumentList "--quiet" -Wait
$displayform.Close()
}

###### Install SCCM ########
If (-not($installed | where name -like "Configuration Manager Client*")) {
Display-WaitForm -Titletext "Installing Software" -LabelText "Please wait while SCCM Agent is installed"
$installer = (get-childitem "$PSScriptRoot\SCCM" -Filter "ccmsetup.exe").Fullname
$sccmArg =  "/noservice /source:`"$PSScriptRoot\sccm`" /BITSpriority:High SMSSITECODE=AIT SMSMP=0100-sccm.applied.global RESETKEYINFORMATION=TRUE /AllowMetered"
Start-Process "$installer" -ArgumentList "$sccmArg" -Wait
$displayform.Close()
}

###### Install Adobe ########
If (-not($installed | where name -like "adobe acrobat*")) {
Display-WaitForm -Titletext "Installing Software" -LabelText "Please wait while Acrobat Reader is installed"
$installer = (get-childitem "$PSScriptRoot\Adobe" -Filter "acro*.exe").Fullname
Start-Process "$installer" -ArgumentList "/sAll /rs" -Wait
$displayform.Close()
}

###### Install Chrome ########
If (-not($installed | where name -like "*Google Chrome*")) {
Display-WaitForm -Titletext "Installing Software" -LabelText "Please wait while Chrome is installed"
$uri = "https://dl.google.com/tag/s/appguid%3D%7B8A69D345-D564-463C-AFF1-A69D9E530F96%7D%26iid%3D%7B37CDA578-10F8-19E2-7AB2-CF865F26857E%7D%26lang%3Den%26browser%3D4%26usagestats%3D0%26appname%3DGoogle%2520Chrome%26needsadmin%3Dtrue%26ap%3Dx64-stable-statsdef_0%26brand%3DGCEA/dl/chrome/install/googlechromestandaloneenterprise64.msi"
$dest = "$PSScriptroot"
Start-BitsTransfer -Source $uri -Destination "$dest"
$switches =  "/i `"$PSScriptroot\googlechromestandaloneenterprise64.msi`" /QN /norestart"
Start-Process  "msiexec.exe" -ArgumentList "$switches" -Wait
$displayform.Close()
}

###### Install Office ########
If (-not($installed | where name -like "*365*")) {
Display-WaitForm -Titletext "Installing Software" -LabelText "Please wait while Office is installed"
Start-Process "$PSSCriptroot\O365-CDN-Install\Setup.exe" -ArgumentList "/configure `"$PSSCriptroot\O365-CDN-Install\Configuration-PC.xml`"" -Wait
$displayform.Close()
}

###### Install Teams ########
If (-not(Get-appxpackage -name "MSTeams")) {
Display-WaitForm -Titletext "Installing Software" -LabelText "Please wait Teams is installed"
Start-Process "$PSSCriptroot\Teams\teamsbootstrapper.exe" -ArgumentList "-p" -Wait
$displayform.Close()
}

###### Install GlobalProtect ########
If (-not($installed | where name -like "*GlobalProtect*")) {
Display-WaitForm -Titletext "Installing Software" -LabelText "Please wait GlobalProtect is installed"
Start-Process "$PSSCriptroot\GlobalProtect\InstallGP.bat" -Wait
$displayform.Close()
}

###### Install WindowsUpdates ########
If (-not(Test-Path "$PSSCriptroot\WindowsUpdate-$(get-date -f dd-MM-yyyy).log")) {
Display-WaitForm -Titletext "Installing Software" -LabelText "Please wait while Windows Updates are installed"
DISM /online /Disable-Feature /FeatureName:"MicrosoftWindowsPowerShellV2" /norestart
$apps = Get-Content "$PSSCriptroot\appx.txt"
Foreach ($app in $apps) {Get-AppxProvisionedPackage -online | Where {$_.DisplayName -eq "$app"} | Remove-AppxProvisionedPackage -AllUsers -Online }

If (-not(Test-Path "C:\Drivers")) {New-Item -Path "C:\Drivers" -ItemType Directory}
Install-PackageProvider -Name "NuGet" -MinimumVersion "2.8.5.021" -Force
Install-Module -Name "PSWindowsUpdate" -Force -Confirm:$false
If (-Not(Get-Module "PSWindowsUpdate")) {Import-Module -Name "PSWindowsUpdate" -Force}
If (Get-Module "PSWindowsUpdate") {
Add-WUServiceManager -ServiceID "7971f918-a847-4430-9279-4a52d1efe18d" -Confirm:$false
Install-WindowsUpdate -Install -AcceptAll -MicrosoftUpdate -ForceDownload -ForceInstall -IgnoreReboot -ErrorAction SilentlyContinue | Out-File "c:\Drivers\WindowsUpdate-$(get-date -f dd-MM-yyyy).log" -Force 
}
$displayform.Close()
$form.Close()
Restart-Computer -Force
}
}
#>

Function Export-Favorites {
param (
 [ValidateSet("Chrome","Edge")]
[string]$browser
)
$ExportedTime = Get-Date -Format 'yyyy-MM-dd'
$HTML_File_Root = "C:\Drivers"
If ($browser -eq "Chrome") {
$JSON_File_Path = "$($env:userprofile)\AppData\Local\Google\Chrome\User Data\Default\Bookmarks"
$HTML_File_Path = "$($HTML_File_Root)\ChromeChromium-Bookmarks.backup_$($ExportedTime).html"
}
else {
$JSON_File_Path = "$($env:userprofile)\AppData\Local\Microsoft\Edge\User Data\Default\Bookmarks"
$HTML_File_Path = "$($HTML_File_Root)\EdgeChromium-Bookmarks.backup_$($ExportedTime).html"
}
# Reference-Timestamp needed to convert Timestamps of JSON (Milliseconds / Ticks since LDAP / NT epoch 01.01.1601 00:00:00 UTC) to Unix-Timestamp (Epoch)
$Date_LDAP_NT_EPOCH = Get-Date -Year 1601 -Month 1 -Day 1 -Hour 0 -Minute 0 -Second 0
<#
if (!(Test-Path -Path $JSON_File_Path -PathType Leaf)) {
    throw "Source-File Path $JSON_File_Path does not exist!" 
}
if (!(Test-Path -Path $HTML_File_Root -PathType Container)) { 
    throw "Destination-Path $HTML_File_Path does not exist!" 
}
#>
# ---- HTML Header ----
$BookmarksHTML_Header = @'
<!DOCTYPE NETSCAPE-Bookmark-file-1>
<!-- This is an automatically generated file.
     It will be read and overwritten.
     DO NOT EDIT! -->
<META HTTP-EQUIV="Content-Type" CONTENT="text/html; charset=UTF-8">
<TITLE>Bookmarks</TITLE>
<H1>Bookmarks</H1>
<DL><p>
'@

$BookmarksHTML_Header | Out-File -FilePath $HTML_File_Path -Force -Encoding utf8

# ---- Enumerate Bookmarks Folders ----
Function Get-BookmarkFolder {
    [cmdletbinding()] 
    Param( 
        [Parameter(Position = 0, ValueFromPipeline = $True)]
        $Node 
    )
    function ConvertTo-UnixTimeStamp {
        param(
            [Parameter(Position = 0, ValueFromPipeline = $True)]
            $TimeStamp 
        )
        $date = [Decimal] $TimeStamp
        if ($date -gt 0) { 
            $date = $Date_LDAP_NT_EPOCH.AddTicks($date * 10)
            $date = $date | Get-Date -UFormat %s 
            $unixTimeStamp = [int][double]::Parse($date) - 1
            return $unixTimeStamp
        }
    }   
    if ($node.name -like "Favorites Bar") {
        $DateAdded = [Decimal] $node.date_added | ConvertTo-UnixTimeStamp
        $DateModified = [Decimal] $node.date_modified | ConvertTo-UnixTimeStamp
        "        <DT><H3 FOLDED ADD_DATE=`"$($DateAdded)`" LAST_MODIFIED=`"$($DateModified)`" PERSONAL_TOOLBAR_FOLDER=`"true`">$($node.name )</H3>" | Out-File -FilePath $HTML_File_Path -Append -Force -Encoding utf8
        "        <DL><p>" | Out-File -FilePath $HTML_File_Path -Append -Force -Encoding utf8
    }
    foreach ($child in $node.children) {
        $DateAdded = [Decimal] $child.date_added | ConvertTo-UnixTimeStamp    
        $DateModified = [Decimal] $child.date_modified | ConvertTo-UnixTimeStamp
        if ($child.type -eq 'folder') {
            "        <DT><H3 ADD_DATE=`"$($DateAdded)`" LAST_MODIFIED=`"$($DateModified)`">$($child.name)</H3>" | Out-File -FilePath $HTML_File_Path -Append -Force -Encoding utf8
            "        <DL><p>" | Out-File -FilePath $HTML_File_Path -Append -Force -Encoding utf8
            Get-BookmarkFolder $child # Recursive call in case of Folders / SubFolders
            "        </DL><p>" | Out-File -FilePath $HTML_File_Path -Append -Force -Encoding utf8
        }
        else {
            # Type not Folder => URL
            "        <DT><A HREF=`"$($child.url)`" ADD_DATE=`"$($DateAdded)`">$($child.name)</A>" | Out-File -FilePath $HTML_File_Path -Append -Encoding utf8
        }
    }
    if ($node.name -like "Favorites Bar") {
        "        </DL><p>" | Out-File -FilePath $HTML_File_Path -Append -Force -Encoding utf8
    }
}

# ---- Convert the JSON Contens (recursive) ----
$data = Get-content $JSON_File_Path -Encoding UTF8 | out-string | ConvertFrom-Json
$sections = $data.roots.PSObject.Properties | Select-Object -ExpandProperty name
ForEach ($entry in $sections) { 
    $data.roots.$entry | Get-BookmarkFolder
}

# ---- HTML Footer ----
'</DL>' | Out-File -FilePath $HTML_File_Path -Append -Force -Encoding utf8
}
If (-not(Test-Path "C:\Drivers\Profwiz")) {
New-Item "C:\Drivers\Profwiz" -ItemType Directory
}
Export-Favorites -browser Chrome
Export-Favorites -browser Edge
Get-Printer | Export-Csv c:\Drivers\InstallPrinters.csv -NoTypeInformation
net use > c:\drivers\mappeddrives.txt
start-process -filePath "ms-settings:workplace" -PassThru
Start-Sleep -Seconds 1
Get-Process SystemSettings | Wait-Process
$wShell = New-Object -COMObject WScript.Shell
Get-Process "msedge" | Stop-Process -Force
Get-Process "chrome" | Stop-Process -Force
$process = Start-Process -FilePath "msedge.exe" -PassThru
Start-Sleep -Seconds 2
$wShell.SendKeys("edge://wallet/passwords?source=passwordssettings{ENTER}")
$process.WaitForExit()
$chrome = Start-Process chrome -passthru
Start-Sleep -Seconds 2
$wShell.SendKeys("chrome://password-manager/settings{ENTER}")
$chrome.WaitForExit()

Add-Type -AssemblyName "Microsoft.VisualBasic"
Add-Type -AssemblyName "System.Windows.Forms" 
Add-Type -AssemblyName "System.Drawing"
Add-Type -AssemblyName System.DirectoryServices.AccountManagement
Add-type -AssemblyName System.DirectoryServices
[void] [System.Windows.Forms.Application]::EnableVisualStyles()

$Profs = (Get-ChildItem "C:\Users" -directory -force | where {$_.name -notlike "* User*" -and $_.name -notlike '$*' -and $_.name -ne "public"}).FullName
Foreach ($prof in $profs) {
If (-not(Test-Path "$prof\AppData\Local\Packages\Microsoft.Windows.StartMenuExperienceHost_cw5n1h2txyewy\LocalState")) {
New-Item "$prof\AppData\Local\Packages\Microsoft.Windows.StartMenuExperienceHost_cw5n1h2txyewy\LocalState" -ItemType Directory
}
Copy-Item "$PSScriptRoot\Start2.bin" -Destination "$prof\AppData\Local\Packages\Microsoft.Windows.StartMenuExperienceHost_cw5n1h2txyewy\LocalState\start2.bin" -Force
}
If (-not(Get-Item "HKLM:\SYSTEM\Setup\MoSetup")) {
New-Item HKLM:\SYSTEM\Setup\MoSetup
}
New-ItemProperty HKLM:\SYSTEM\Setup\MoSetup -PropertyType DWORD -Name AllowUpgradesWithUnsupportedTPMOrCPU -Value 1 -Force
If (-not(Get-Item HKLM:\Software\Policies\Microsoft\Dsh)) {
New-Item HKLM:\Software\Policies\Microsoft\Dsh
}
New-ItemProperty HKLM:\Software\Policies\Microsoft\Dsh -PropertyType DWORD -Name AllowNewsAndInterests -Value 0 -Force
If (-not(Get-Item "HKLM:\Software\Policies\Microsoft\Windows\Windows Chat")) {
New-Item "HKLM:\Software\Policies\Microsoft\Windows\Windows Chat"
}
New-ItemProperty "HKLM:\Software\Policies\Microsoft\Windows\Windows Chat" -PropertyType DWORD -Name ChatIcon -Value 3 -Force
New-ItemProperty "HKLM:\SOFTWARE\Microsoft\Windows\CurrentVersion\Policies\System" -Name EnableMPR -PropertyType DWORD -Value 1 -Force
#net use * /d /y
$DNSRoot = "applied.global"
$DN = "DC=applied,DC=global"
$NetBios = "APPLIEDGLOBAL"
$DomainController = "1100-AGDC120.applied.global"
#$LocData = import-csv $PSScriptRoot\importdata.csv
$locList = $LocData | select -Unique Loc,City | Foreach {
Write-Output "$($_.loc) - $($_.City)"
}
$global:sn = (Get-WmiObject Win32_BIOS).SerialNumber
$compsys = Get-WmiObject -Class Win32_ComputerSystem
If ($compsys.Manufacturer -notlike "*lenovo*") {
$global:model = $compsys.Model
$global:manufacturer = $compsys.Manufacturer
$result = Get-DellWarranty -serialNumber $sn
}
else {
$compsys = Get-WmiObject -Class Win32_ComputerSystemProduct
$global:model = $compsys.Version
$global:manufacturer = $compsys.Vendor
$result = Get-LenovoWarranty -SerialNumber $sn
}

If ($compsys.Manufacturer -like "*VMWare*") {
$global:sn = "5JH7FZ3"
$result = Get-DellWarranty -serialNumber $sn
}
If ($result) {
$YearMonth = Get-Date $result.Start -Format yyMM
$warranty = $true}
else {
$YearMonth = Get-Date -Format yyMM
$warranty = $false}

$regPath = "HKLM:\Software\AIT-Warranty"
If ($result) {
If (-not(Get-Item $regPath)) {
New-Item $regPath
}
Set-ItemProperty -Path $regPath -Name Description -Value $result.Name-Force
Set-ItemProperty -Path $regPath -Name Manufacturer -Value $manufacturer -Force
Set-ItemProperty -Path $regPath -Name StartDate -Value $result.Start -Force
Set-ItemProperty -Path $regPath -Name EndDate -Value $result.end -Force
#$YearMonth = Get-Date $result.end -Format yyMM
$warranty = $true
#$rnd = Random
}
$description = "$manufacturer $model | SN# $sn | Warranty End $($result.end)"
#>
    If ((Get-WmiObject -Class Win32_Battery)) {
	$type = "LT"
    $oufolder = "Laptops"
    }
	else
	{
    $type = "DT"
    $oufolder = "Desktops"
    }

$local = & "whoami"
$local = $local -split "\\"
$searcher = $null
$adsi = $null
. Load-FormObjects
. Set-Buttons
. Set-FormBase
